/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8275d;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMWizardInfo;
import ibm.nways.jdm.eui.JDMWizardPanelDelegate;
import ibm.nways.jdm.eui.MessageBox;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class TrapDelete
implements JDMWizardPanelDelegate {
    private static ResourceBundle myResources = ResourceBundle.getBundle("ibm.nways.jdm8275d.GeneralResources");
    public static final int RASID = 19;
    public static final int RASSUB = 8;
    protected DestinationPropBook myBook;
    protected JdmBrowser browser;
    NavigationContext myContext;
    MessageBox messageToUser;
    boolean okayToDelete = true;
    IPAddress deleteTrap;

    public void setDefaults(JDMWizardInfo jDMWizardInfo) {
        boolean bl = true;
        ModelInfo modelInfo = null;
        String string = "setDefaults";
        if (RAS.isEnabled(19, 8)) {
            RAS.enter(19, 8, this, string);
        }
        this.myBook = (DestinationPropBook)jDMWizardInfo.getPropertyBook();
        if (this.browser == null && this.myBook != null) {
            this.browser = (JdmBrowser)this.myBook.getBrowser();
        }
        if (this.browser == null) {
            if (RAS.isEnabled(19, 8)) {
                RAS.trace(19, 8, this, string, "Can't get browser- can't proceed with delete");
            }
            bl = false;
        }
        if (bl) {
            modelInfo = jDMWizardInfo.getCurrentRow();
            Hashtable hashtable = jDMWizardInfo.getItems();
            if (modelInfo != null && modelInfo.get("Index.TrapIp") instanceof IPAddress) {
                this.deleteTrap = (IPAddress)modelInfo.get("Index.TrapIp");
                hashtable.put("confirmTrapIp", this.deleteTrap);
                hashtable.put("confirmTrapCommString", modelInfo.get("Panel.TrapCommString"));
                this.okayToDelete = true;
                this.browser.displayMsg(TrapDelete.getNLSString("WZ_deleteConfirm"));
            } else {
                hashtable.put("confirmTrapIp", " ");
                hashtable.put("confirmTrapCommString", " ");
                this.okayToDelete = false;
                this.browser.displayMsg(TrapDelete.getNLSString("Trap_NoTrap"));
                if (RAS.isEnabled(19, 8)) {
                    RAS.trace(19, 8, this, string, "No trap exists to be deleted");
                }
            }
        }
        if (RAS.isEnabled(19, 8)) {
            RAS.exit(19, 8, this, string);
        }
    }

    public boolean abort(JDMWizardInfo jDMWizardInfo) {
        this.myBook = (DestinationPropBook)jDMWizardInfo.getPropertyBook();
        if (this.browser == null && this.myBook != null) {
            this.browser = (JdmBrowser)this.myBook.getBrowser();
        }
        this.displayMsg(TrapDelete.getNLSString("Trap_DeleteAbort"));
        return true;
    }

    public boolean proceed(JDMWizardInfo jDMWizardInfo) {
        boolean bl = true;
        GenModel genModel = null;
        String string = null;
        String string2 = "proceed";
        if (RAS.isEnabled(19, 8)) {
            RAS.enter(19, 8, this, string2);
        }
        if (this.browser == null && this.myBook != null) {
            this.browser = (JdmBrowser)this.myBook.getBrowser();
        }
        if (this.browser == null) {
            if (RAS.isEnabled(19, 8)) {
                RAS.trace(19, 8, this, string2, "Can't get browser- can't proceed with create");
            }
            bl = false;
        }
        if (bl && !this.okayToDelete) {
            if (RAS.isEnabled(19, 8)) {
                RAS.trace(19, 8, this, string2, "Table is empty. No Trap can be selected for deletion.");
            }
            string = new String("Trap_NoTrap");
            bl = false;
        } else {
            try {
                genModel = jDMWizardInfo.getModel();
                ModelInfo modelInfo = new ModelInfo();
                modelInfo.add("Index.TrapIp", this.deleteTrap);
                modelInfo.add("Panel.TrapStatus", new Integer(1));
                modelInfo = genModel.setInfo("Panel", modelInfo);
                if (modelInfo.timeoutDetected) {
                    if (RAS.isEnabled(19, 8)) {
                        RAS.trace(19, 8, this, string2, "Set to delete Trap Ip " + this.deleteTrap + " failed due to timeout");
                    }
                    string = new String("WZ_badSetTimeout");
                    bl = false;
                }
                Enumeration enumeration = modelInfo.getItemIds();
                while (enumeration.hasMoreElements() && bl) {
                    String string3 = (String)enumeration.nextElement();
                    Serializable serializable = modelInfo.get(string3);
                    if (!(serializable instanceof SpecialValue)) continue;
                    if (RAS.isEnabled(19, 8)) {
                        RAS.trace(19, 8, this, string2, "Set to delete Trap Ip " + this.deleteTrap + " failed");
                    }
                    string = new String("WZ_rejectDelete");
                    bl = false;
                }
            }
            catch (Exception exception) {
                if (RAS.isEnabled(19, 8)) {
                    RAS.trace(19, 8, this, string2, "Error setting info.");
                }
                RAS.logException(19, 8, this, string2, exception);
                string = new String("WZ_badSetDelete");
                bl = false;
            }
        }
        if (bl) {
            this.browser.displayMsg(TrapDelete.getNLSString("Trap_DeleteOK"));
        } else if (this.browser != null) {
            this.browser.displayMsg(TrapDelete.getNLSString(string));
            this.messageToUser = new MessageBox(this.browser.getFrame(), TrapDelete.getNLSString("Trap_DeleteError"), TrapDelete.getNLSString(string), true);
        }
        if (RAS.isEnabled(19, 8)) {
            RAS.exit(19, 8, this, string2);
        }
        return bl;
    }

    protected void displayMsg(String string) {
        if (this.browser != null) {
            this.browser.displayMsg(string);
        }
    }

    protected static String getNLSString(String string) {
        String string2 = null;
        try {
            string2 = myResources.getString(string);
        }
        catch (Exception exception) {
            try {
                string2 = myResources.getString(string);
            }
            catch (Exception exception2) {
                string2 = string;
            }
        }
        return string2;
    }

    private boolean checkSnmpResponse(ModelInfo modelInfo) {
        boolean bl = false;
        String string = "checkSnmpResponse";
        if (RAS.isEnabled(19, 8)) {
            RAS.enter(19, 8, this, string);
        }
        Enumeration enumeration = modelInfo.getItemIds();
        while (enumeration.hasMoreElements()) {
            bl = true;
            String string2 = (String)enumeration.nextElement();
            Serializable serializable = modelInfo.get(string2);
            if (!(serializable instanceof SpecialValue)) continue;
            if (RAS.isEnabled(19, 8)) {
                RAS.trace(19, 8, this, string, "Error in snmp set. Variable is " + string2 + "  SpecialValue is " + serializable);
            }
            bl = false;
            break;
        }
        if (RAS.isEnabled(19, 8)) {
            RAS.exit(19, 8, this, string);
        }
        return bl;
    }
}

